package main

import (
	"fmt"
	"math/rand"
	"net/http"
	"strconv"
	"strings"
	"time"
)

// generating data for POST and PUT requests
func randString(l int) string {
	bytes := make([]byte, l)
	for i := 0; i < l; i++ {
		bytes[i] = byte(randInt(65, 90))
	}
	return string(bytes)
}

func randInt(min int, max int) int {
	return min + rand.Intn(max-min)
}

func bodyAdd() string {
	name := randString(5)
	surname := randString(10)
	body := fmt.Sprintf(`[{"list_id":1,"tag_ids":[1,2],"vcard":{"names":[{"first":"%[1]s","last":"%[2]s"}],"emails":[{"email":"%[1]s@%[2]s.test"}]}}]`, name, surname)
	return body
}

// Body for adding e-mails via /emails handler
func bodyEmails(count int) string {
	body := ``
	pice := randString(9)
	start := `{"to":[`
	end := `]}`
	zone := `.test`
	copy := `], "cc":[{`
	switch count {
	case 1:
		to := `"` + pice + `@` + pice + zone + `"`
		body += start + to
	case 2:
		to := `"` + pice + `@` + pice + zone + `"`
		cc := `"` + pice + `_1@` + pice + `_1` + zone + `"`
		body += start + to + copy + cc
	default:
		to := `"` + pice + `@` + pice + zone + `"`
		cc := `"` + pice + `_1@` + pice + `_1` + zone + `"`
		body += start + to + copy + cc
		for i := 2; i < count; i++ {
			piceCC := pice + `_` + strconv.Itoa(i)
			body += `,"` + piceCC + `@` + piceCC + zone + `"`
		}
	}
	body += end
	return body
}

// Body for multiget request
func getURI(count int) string {
	uri := `<href>rfc`
	for i := 1; i < count; i++ {
		uri += `</href><href>rfc` + strconv.Itoa(i)
	}
	uri += `</href>`
	return uri
}

func makeTimestamp() string {
	return time.Now().Format("15:04:05.000000")
}

func (g *Gun) makeReq(payload *Payload) *http.Request {
	req, _ := http.NewRequest(payload.Method, strings.Join([]string{"http://", g.conf.Target, "/v1/users/", payload.URI}, ""), strings.NewReader(payload.Data))
	req.Header.Add("Connection", "close")
	req.Header.Add("X-Real-IP", "213.180.206.57")
	req.Header.Add("X-Request-Id", payload.Xrequestid)
	req.Header.Add("User-Agent", "pandora")
	req.Header.Add("Content-Type", "application/json")
	return req
}

func (g *Gun) genPayload(ammo *Ammo) *Payload {
	payload := Payload{
		Assert:     `"status":"error"`,
		Xrequestid: fmt.Sprintf("%s_%s", makeTimestamp(), ammo.UID),
		Data:       "",
	}
	switch ammo.Tag {
	case "add_contact":
		payload.Method = "POST"
		payload.URI = fmt.Sprintf("%s/contacts", ammo.UID)
		payload.Data = bodyAdd()

	case "add_emails":
		payload.Method = "POST"
		payload.URI = fmt.Sprintf("%s/contacts/emails", ammo.UID)
		payload.Data = bodyEmails(ammo.Count)

	case "put_contact": // need to modify
		payload.Method = "PUT"
		payload.URI = fmt.Sprintf("%s/contacts", ammo.UID)
		payload.Data = bodyAdd()

	case "del_contact": // need to modify
		payload.Method = "DELETE"
		payload.URI = fmt.Sprintf("%s/contacts/[%s]", ammo.UID, cidsCluer(ammo))

	case "get_count":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/contacts/count", ammo.UID)

	case "get_contacts":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/contacts/[%s]", ammo.UID, cidsCluer(ammo))

	case "all_contacts":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/contacts/[]", ammo.UID)

	case "mixin_contacts":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/contacts/[]?mixin=true", ammo.UID)

	case "get_tags":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/tags", ammo.UID)

	case "get_emails":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/emails/[1,2]", ammo.UID)

	case "tag_contacts":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/tags/1/contacts", ammo.UID)

	case "get_list":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/shared/lists", ammo.UID)

	case "list_contacts":
		payload.Method = "GET"
		uid, _ := strconv.Atoi(ammo.UID)
		payload.URI = fmt.Sprintf("%s/shared/lists/%d/contacts/[]", ammo.UID, (4 + uid%2))

	case "list_count":
		payload.Method = "GET"
		uid, _ := strconv.Atoi(ammo.UID)
		payload.URI = fmt.Sprintf("%s/shared/lists/%d/contacts/count", ammo.UID, (4 + uid%2))

	case "get_changes":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/changes", ammo.UID)

	case "restore_contacts":
		payload.Method = "POST"
		payload.URI = fmt.Sprintf("%s/changes/%s", ammo.UID, strconv.Itoa(randInt(1, 11)))
		payload.Data = ""

	case "multiget":
		payload.Method = "POST"
		payload.URI = fmt.Sprintf("%s/carddav/multiget", ammo.UID)
		payload.Data = fmt.Sprintf("<request>%s</request>", getURI(ammo.Count))

	case "propfind":
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/carddav/propfind", ammo.UID)

	case "put_vcard":
		payload.Method = "POST"
		payload.URI = ammo.UID + "/carddav/ya-" + ammo.UID + "/put/%2A"
		payload.Data = "BEGIN:VCARD;\nVERSION:3.0;\nEMAIL:CARD@DAV.test;\nFN:CARD DAV;\nTEL:+74956441306;\nEND:VCARD;"

	default:
		payload.Method = "GET"
		payload.URI = fmt.Sprintf("%s/location", ammo.UID)
	}

	return &payload
}

func cidsCluer(ammo *Ammo) string {
	var output string
	for i := 0; i < ammo.Count; i++ {
		if len(output) != 0 {
			output += `,`
		}
		output += state[ammo.UID].CIDs[i]
	}
	return output
}
