import sys
import random
import json
import os.path

# Create lists of user's IDs
# list for users with count contacts less than 10
grand_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
small=[]
with open(os.path.join(grand_dir, "files/", "10.list"), "r") as ulist:
    for line in ulist:
        small.append(line)

# list for users with count contacts more than 10 and less than 100
middle=[]
with open(os.path.join(grand_dir, "files/", "100.list"), "r") as ulist:
    for line in ulist:
        middle.append(line)

# list for users with count contacts more than 100 and less than 1000
big=[]
with open(os.path.join(grand_dir, "files/", "1000.list"), "r") as ulist:
    for line in ulist:
        big.append(line)

# list for users with count contacts more than 1000 and less than 10000
large=[]
with open(os.path.join(grand_dir, "files/", "10000.list"), "r") as ulist:
    for line in ulist:
        large.append(line)


# choice weighted uid
def weighted_json_choice(choices):
    '''dict where key is choice and value probability'''
    total = sum(choices[choice] for choice in choices)
    r = random.uniform(0, total)
    upto = 0
    for choice in choices:
        if upto + choices[choice] >= r:
            return choice
        upto += choices[choice]


class Ammo(object):
    def __init__(self, args):
        self.output = []
        self.maxcount = int(float(args[2]))
        self.distr = self.set_distr_from_json(args[1])
        self.uids_list = {"get_contacts": big,
                          "all_contacts": big,
                          "tag_contacts": big, 
                          "add_contact": small,
                          "put_contact": small,
                          "del_contact": small,
                          "get_tags": big,
                          "add_emails": small,
                          "get_emails": big,
                          "get_count": large,
                          "get_lists": middle,
                          "list_contacts": middle,
                          "list_count": middle,
                          "get_changes": small,
                          "restore_contacts": small,
                          "multiget": middle,
                          "propfind": middle,
                          "put_vcard": middle,
                          "mixin_contacts": middle
                          }


    def set_distr_from_json(self, input_json):
        profile = json.loads(input_json.replace(" ", "").replace("\n", ""))
        out = []
        for i in xrange(400000):
            out.append(weighted_json_choice(profile))
        return out


    def make_ammo(self):
        with open("ammo.json", "w") as fd:
            for t in self.distr:
                line = '{"tag": "%s", "count": %d, "uid": "%s"}\n' % (str(t), self.choice_count(t), self.get_uid(t))
                fd.write(line)


    def get_uid(self, tag):
        r = int(random.uniform(0, len(self.uids_list[tag])))
        return str(self.uids_list[tag][r]).replace(" ", "").replace("\n","")


    def choice_count(self, tag):
        noones = ("get_contacts", "add_emails", "multiget")
        if tag in noones:
            r = random.uniform(1, self.maxcount + 1)
        else:
            r = 1
        return int(r)


if __name__ == "__main__":
    ammo = Ammo(sys.argv)
    ammo.make_ammo()
