#!/usr/bin/env /usr/bin/python
import argparse
import psycopg2


def clean_mixin(dbhost, dbport, dbname, dbuser, dbpass):
    for host in dbhost:
        conn = psycopg2.connect(
            dbname=dbname,
            user=dbuser,
            password=dbpass,
            port=dbport,
            host=host
        )
        cursor = conn.cursor()
        cursor.execute('SELECT pg_is_in_recovery()')
        is_slave = cursor.fetchall()
        conn.commit()
        if is_slave[0][0]:
            continue
        else:
            # get the list of users for organizations
            cursor.execute(
                "SELECT user_id, user_type, list_id, client_user_id, client_user_type FROM contacts.shared_lists"
            )
            shared = cursor.fetchall()
            conn.commit()
            # clean table contacts.shared_lists
            for i in range(len(shared)-1, -1, -1):
                cursor.execute(
                    "SELECT code.revoke_contacts_list({0}, '{1}', {2}, {3}, '{4}', 'after_shoot')".format(*shared[i])
                )
                conn.commit()
            # get the list of organizations for users
            cursor.execute(
                "SELECT user_id, user_type, list_id, owner_user_id, owner_user_type, owner_list_id FROM contacts.subscribed_lists"
            )
            subscribed = cursor.fetchall()
            conn.commit()
            # clean table contacts.shared_lists
            for i in range(len(subscribed)-1, -1, -1):
                cursor.execute(
                    "SELECT code.revoke_subscribed_contacts_list({0}, '{1}', {2}, {3}, '{4}', {5}, 'after_shoot')".format(*subscribed[i])
                )
                conn.commit()
                cursor.execute(
                    "DELETE FROM contacts.lists WHERE user_id = {0} AND user_type = '{1}' AND list_id = {2}".format(*subscribed[i])
                )
                conn.commit()
        cursor.close()
        conn.close()
# Finishing of the cleaning


if __name__ == "__main__":

    parser = argparse.ArgumentParser()
    parser.add_argument("--dbhost", type=str, default=('man-arc5izadywspu1dq.db.yandex.net sas-w0ckruj66882d0hz.db.yandex.net vla-s8vr9k65cww07cb5.db.yandex.net'))
    parser.add_argument("--dbport", type=str, default='6432')
    parser.add_argument("--dbname", type=str, default='maildb')
    parser.add_argument("--dbuser", type=str, default='collie')
    parser.add_argument("--dbpass", type=str)
    args = parser.parse_args()

    clean_mixin(args.dbhost.split(), args.dbport, args.dbname, args.dbuser, args.dbpass)
