#!/usr/bin/env /usr/bin/python
import psycopg2
import argparse

LISTS = ("INSERT INTO contacts.lists values({:d}, 'passport_user', 4, 1, 'LinkToFour', 'user', true) ON CONFLICT DO NOTHING",
         "INSERT INTO contacts.lists values({:d}, 'passport_user', 5, 1, 'LinkToFive', 'user', true) ON CONFLICT DO NOTHING")
SHARED_LISTS = ("INSERT INTO contacts.shared_lists VALUES(4000000004, 'connect_organization', 4, {:d}, 'passport_user', 1) ON CONFLICT DO NOTHING",
                "INSERT INTO contacts.shared_lists VALUES(5000000005, 'connect_organization', 5, {:d}, 'passport_user', 1) ON CONFLICT DO NOTHING")
SUBSCRIBED_LISTS = ("INSERT INTO contacts.subscribed_lists VALUES({:d}, 'passport_user', 4, 4000000004, 'connect_organization', 4, 1) ON CONFLICT DO NOTHING",
                    "INSERT INTO contacts.subscribed_lists VALUES({:d}, 'passport_user', 5, 5000000005, 'connect_organization', 5, 1) ON CONFLICT DO NOTHING")


def init_lists(hosts, uids, subscribe):
    for host in hosts:
        conn = psycopg2.connect(dbname=args.dbname, user=args.dbuser, password=args.dbpass, port=args.dbport, host=host)
        cursor = conn.cursor()
        cursor.execute('SELECT pg_is_in_recovery()')
        is_slave = cursor.fetchall()
        conn.commit()
        if is_slave[0][0]:
            continue
        else:
            # get the list of users for organizations
            for uid in uids:
                # insert into contacts.lists
                cursor.execute(LISTS[uid % 2].format(uid))
                conn.commit()
                # insert into contacts.shared_lists
                if subscribe == "yes":
                    cursor.execute(SHARED_LISTS[uid % 2].format(uid))
                    conn.commit()
                    # insert into contacts.subscribed_lists
                    cursor.execute(SUBSCRIBED_LISTS[uid % 2].format(uid))
                    conn.commit()

        cursor.close()
        conn.close()


if __name__ == "__main__":

    parser = argparse.ArgumentParser()
    parser.add_argument("--dbhost", type=str, default='man-arc5izadywspu1dq.db.yandex.net sas-w0ckruj66882d0hz.db.yandex.net vla-s8vr9k65cww07cb5.db.yandex.net')
    parser.add_argument("--dbport", type=str, default='6432')
    parser.add_argument("--dbname", type=str, default='maildb')
    parser.add_argument("--dbuser", type=str, default='collie')
    parser.add_argument("--dbpass", type=str)
    parser.add_argument("--source", type=str)
    parser.add_argument("--subscribe", type=str, default='yes')
    args = parser.parse_args()

    uids = []
    try:
        with open(args.source, 'r') as source:
            for line in source:
                uids.append(int(line.strip()))
    except Exception as ex:
        print("File not found", ex)

    if len(uids) > 0:
        init_lists(args.dbhost.split(), uids, args.subscribe)
    else:
        print("No uids for subscribe")
