#!/bin/bash -e

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to link ephemeral, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for srv in $(echo "dict.dict queryrec.dict queryrec.weights"); do
    for i in {1..10}; do
        if [[ -f "/usr/share/recognizer/$srv" ]]; then
            echo "ok"
            break
        else
            echo "No $srv found, sleeping"
            sleep 5
        fi
    done

    if [[ "$i" -eq 10 ]]; then
        echo "Failed to find $srv, cannot start"
        exit 1
    fi
done

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /secrets/ssl ]]; then
        echo "copying crt"
        rsync -av /secrets/ssl/ /etc/nginx/ssl/

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No crt, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/.pgpass ]]; then
        echo "copying pgpass"
        cp -f /secrets/.pgpass /etc/collie/.pgpass

        echo "chowning pgpass"
        chown collie:collie /etc/collie/.pgpass

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No pgpass found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to chown pgpass, cannot start"
    exit 1
fi

for i in {1..10}; do
    if [[ -f /secrets/tvm_secret ]]; then
        echo "Copy tvm secret"
        cp -f /secrets/tvm_secret /etc/collie/tvm_secret

        echo "Chown tvm secret"
        chown collie:collie /etc/collie/tvm_secret

        break
    else
        echo "Tvm secret is not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to chown tvm_secret, cannot start"
    exit 1
fi

if [[ -z "${ENVIRONMENT_TYPE}" ]]; then
    echo "[ERROR] ENVIRONMENT_TYPE is not set, cannot start. Supported environments: production, intranet-production, testing, stress"
    exit 1
fi

if [[ "${ENVIRONMENT_NAME}" ]]; then
    ENVIRONMENT="${ENVIRONMENT_NAME}-${ENVIRONMENT_TYPE}"
else
    ENVIRONMENT="${ENVIRONMENT_TYPE}"
fi

ln -sf /etc/collie/config-${ENVIRONMENT}.yml /etc/collie/config.yml
ln -sf /etc/nginx/sites-available/collie.include /etc/nginx/sites-enabled/collie.include
ln -sf /etc/nginx/sites-available/log_by_lua.include /etc/nginx/sites-enabled/log_by_lua.include
ln -sf /etc/nginx/sites-available/collie.conf-${ENVIRONMENT} /etc/nginx/sites-enabled/collie.conf
ln -sf /etc/nginx/sites-available/unistat.conf /etc/nginx/sites-enabled/unistat.conf

# sending collie logs from production, intranet-production and intranet-sync environments
if [[ "${ENVIRONMENT}" == "production" ]] || [[ "${ENVIRONMENT}" == "intranet-production" ]] || [[ "${ENVIRONMENT}" == "intranet-sync" ]]; then
    ln -sf /etc/supervisor/conf.d/push-client-collie-log.conf-${ENVIRONMENT} /etc/supervisor/conf.d/push-client-collie-log.conf
fi

# configure load environment
if [[ "${ENVIRONMENT_TYPE}" == "load" ]]; then
    source /opt/load.sh
fi

app=collie
ln -sf /usr/share/collie/collie.md /usr/share/collie/about

