#include "config.hpp"

#include <yamail/data/reflection/reflection.h>

YREFLECTION_ADAPT_ADT(ozo::connection_pool_timeouts,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_ms, std::chrono::milliseconds, connect)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, queue_ms, std::chrono::milliseconds, queue)
)

YREFLECTION_ADAPT_ADT(collie::server::Config,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, web_server_module, webServerModule)
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, coroutine_stack_size, coroutineStackSize)
)

YREFLECTION_ADAPT_ADT(ymod_httpclient::timeouts,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_ms, yplatform::time_traits::milliseconds, connect)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, total_ms, yplatform::time_traits::milliseconds, total)
)

BOOST_FUSION_ADAPT_STRUCT(ymod_httpclient::options,
    log_post_body,
    log_headers,
    reuse_connection,
    timeouts
)

BOOST_FUSION_ADAPT_STRUCT(pgg::Credentials,
    user,
    password
)

YREFLECTION_ADAPT_ADT(ozo::connection_pool_config,
    YREFLECTION_WO_MEMBER(std::size_t, capacity)
    YREFLECTION_WO_MEMBER(std::size_t, queue_capacity)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, idle_timeout_ms, std::chrono::milliseconds, idle_timeout)
)

YREFLECTION_ADAPT_ADT(collie::services::db::Timeouts,
    YREFLECTION_WO_MEMBER_RENAMED(ozo::connection_pool_timeouts, connection_pool, connectionPool)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, request_ms, std::chrono::milliseconds, request)
)

YREFLECTION_ADAPT_ADT(collie::services::db::contacts::Config,
    YREFLECTION_WO_MEMBER(pgg::Credentials, credentials)
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, max_total_pools_capacity, maxTotalPoolsCapacity)
    YREFLECTION_WO_MEMBER_RENAMED(ozo::connection_pool_config, connection_pool, connectionPool)
    YREFLECTION_WO_MEMBER(collie::services::db::Timeouts, timeouts)
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, max_retries_number, maxRetriesNumber)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, query_conf, queryConf)
    YREFLECTION_WO_MEMBER_RENAMED(collie::services::sharpei::Config, org_sharpei, orgSharpei)
    YREFLECTION_WO_MEMBER_RENAMED(collie::services::sharpei::Config, user_sharpei, userSharpei)
)

YREFLECTION_ADAPT_ADT(collie::services::db::events_queue::Config,
    YREFLECTION_WO_MEMBER(pgg::Credentials, credentials)
    YREFLECTION_WO_MEMBER(collie::services::db::Timeouts, timeouts)
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, max_total_pools_capacity, maxTotalPoolsCapacity)
    YREFLECTION_WO_MEMBER_RENAMED(ozo::connection_pool_config, connection_pool, connectionPool)
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, max_retries_number, maxRetriesNumber)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, query_conf, queryConf)
    YREFLECTION_WO_MEMBER(collie::services::sharpei::Config, sharpei)
)

YREFLECTION_ADAPT_ADT(collie::services::db::Config,
    YREFLECTION_WO_MEMBER(collie::services::db::contacts::Config, contacts)
    YREFLECTION_WO_MEMBER_RENAMED(collie::services::db::events_queue::Config, events_queue, eventsQueue)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::client::http::Address,
    host,
    port
)

YREFLECTION_ADAPT_ADT(sharpei::client::Settings,
    YREFLECTION_WO_MEMBER_RENAMED(sharpei::client::http::Address, address, sharpeiAddress)
    YREFLECTION_WO_MEMBER(unsigned, retries)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, timeout_ms, std::chrono::milliseconds, timeout)
    YREFLECTION_WO_MEMBER_RENAMED(bool, keep_alive, keepAlive)
)

YREFLECTION_ADAPT_ADT(collie::services::sharpei::Config,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_timeout_ms,
        yplatform::time_traits::milliseconds, connectTimeout)
    YREFLECTION_WO_MEMBER(sharpei::client::Settings, client)
)

YREFLECTION_ADAPT_ADT(collie::services::directory::Config,
    YREFLECTION_WO_MEMBER(std::string, location)
    YREFLECTION_WO_MEMBER(std::size_t, retries)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, instant_messengers, instantMessengers)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, social_profiles, socialProfiles)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, target_service_name, targetServiceName)
    YREFLECTION_WO_MEMBER_RENAMED(ymod_httpclient::options, http_options, httpOptions)
)

YREFLECTION_ADAPT_ADT(collie::services::recognizer::Config,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, language_dict, languageDict)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, language_weights, languageWeights)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, encoding_dict, encodingDict)
)

YREFLECTION_ADAPT_ADT(collie::services::staff::Config,
    YREFLECTION_WO_MEMBER(std::string, location)
    YREFLECTION_WO_MEMBER(std::size_t, limit)
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, page_max_count, pageMaxCount)
    YREFLECTION_WO_MEMBER(std::size_t, retries)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, instant_messengers, instantMessengers)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, social_profiles, socialProfiles)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, target_service_name, targetServiceName)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, http_client_module, httpClientModule)
    YREFLECTION_WO_MEMBER_RENAMED(ymod_httpclient::options, http_options, httpOptions)
)

YREFLECTION_ADAPT_ADT(collie::services::ml::Config,
    YREFLECTION_WO_MEMBER(std::string, location)
    YREFLECTION_WO_MEMBER(std::size_t, retries)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, target_service_name, targetServiceName)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, http_client_module, httpClientModule)
    YREFLECTION_WO_MEMBER_RENAMED(ymod_httpclient::options, http_options, httpOptions)
)

YREFLECTION_ADAPT_ADT(collie::services::Config,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, http_client_module, httpClientModule)
    YREFLECTION_WO_MEMBER(collie::services::db::Config, db)
    YREFLECTION_WO_MEMBER(collie::services::directory::Config, directory)
    YREFLECTION_WO_MEMBER(collie::services::staff::Config, staff)
    YREFLECTION_WO_MEMBER(collie::services::ml::Config, ml)
    YREFLECTION_WO_MEMBER(collie::services::recognizer::Config, recognizer)
)

YREFLECTION_ADAPT_ADT(collie::Config,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, profiler_log_name, profilerLogName)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, event_queue_module, eventQueueModule)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, tvm_module, tvmModule)
    YREFLECTION_WO_MEMBER(collie::server::Config, server)
    YREFLECTION_WO_MEMBER(collie::services::Config, services)
)
