#pragma once

#include "config.hpp"
#include "module_interface.hpp"
#include "sync_event_queue.hpp"

#include <yplatform/module.h>

namespace collie::directory_sync::event_queue {

class Module : public ModuleInterface, public yplatform::module {
public:
    Module(boost::asio::io_context& io, const yplatform::ptree& configurationData);
    void start();
    void stop();

private:
    virtual void addEvent(logic::NewEvent newEvent) override;
    void scheduleEventQueueSync();
    void sync();

    std::reference_wrapper<boost::asio::io_context> io;
    Config config;
    SyncEventQueueContextPtr syncEventQueueContext;
    boost::asio::deadline_timer timer;
    boost::asio::deadline_timer::time_type syncTime;
    EventInfoByOrgId eventInfoByOrgId;
    bool syncIsOngoing{false};
};

} // namespace collie::directory_sync::event_queue
