#include "run_sync_event_queue.hpp"

namespace collie::directory_sync::event_queue {

RunSyncEventQueue::RunSyncEventQueue(const SyncEventQueueContextPtr& syncEventQueueContext,
        MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider)
    : syncEventQueueContext(syncEventQueueContext)
    , makeEventsQueueConnectionProvider(std::move(makeEventsQueueConnectionProvider)) {
}

void RunSyncEventQueue::operator()(boost::asio::yield_context yield, const Config& config,
        EventInfoByOrgId& eventInfoByOrgId) const {
    const auto id{yplatform::task_context().uniq_id()};
    const std::string userIp{"127.0.0.1"};
    const std::string clientType{"directory_event_queue_sync_worker"};
    const auto taskContext{boost::make_shared<TaskContext>(id, id, userIp, clientType, yield)};
    syncEventQueueContext->setTaskContext(taskContext);
    try {
        LOGDOG_(taskContext->logger(), notice, log::message=clientType + " is started");
        const SyncEventQueue syncEventQueue{*syncEventQueueContext, makeEventsQueueConnectionProvider,
                config};
        syncEventQueue(eventInfoByOrgId);
        LOGDOG_(taskContext->logger(), notice, log::message=clientType + " is stopped");
    } catch (const boost::coroutines::detail::forced_unwind&) {
        throw;
    } catch (const std::exception& ex) {
        logException(taskContext->logger(), ex);
    } catch (...) {
        LOGDOG_(taskContext->logger(), error, log::message=clientType + " unknown error");
    }
}

} // namespace collie::directory_sync::event_queue
