#pragma once

#include "config.hpp"
#include "sync_event_queue.hpp"

#include <src/services/db/events_queue/make_connection_provider.hpp>

namespace collie::directory_sync::event_queue {

class RunSyncEventQueue {
public:
    using MakeEventsQueueConnectionProvider = services::db::events_queue::MakeConnectionProvider;
    RunSyncEventQueue(const SyncEventQueueContextPtr& syncEventQueueContext,
            MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider);
    void operator()(boost::asio::yield_context yield, const Config& config,
            EventInfoByOrgId& eventInfoByOrgId) const;

private:
    SyncEventQueueContextPtr syncEventQueueContext;
    MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider;
};

} // namespace collie::directory_sync::event_queue
