#pragma once

#include <src/task_context.hpp>

namespace collie::directory_sync::event_queue {

class SyncEventQueueContext {
public:
    void setTaskContext(TaskContextPtr taskContextToSet) {
        taskContext = taskContextToSet;
    }

    TaskContextPtr getTaskContext() const {
        return taskContext;
    }

    const boost::asio::yield_context& yield() const {
        return taskContext->yield();
    }

    const RequestLogger& logger() const {
        return taskContext->logger();
    }

    bool mustStop() const {
        return stopSyncEventQueue;
    }

    void stop() {
        stopSyncEventQueue = true;
    }

private:
    TaskContextPtr taskContext;
    std::atomic_bool stopSyncEventQueue{false};
};

using SyncEventQueueContextPtr = std::shared_ptr<SyncEventQueueContext>;

} // namespace collie::directory_sync::event_queue
