#include "module.hpp"
#include "config.hpp"
#include "config_reflection.hpp"

#include <yplatform/module_registration.h>

#include <yamail/data/deserialization/ptree.h>

#include <pa/async.h>

namespace collie::directory_sync {

Module::Module(boost::asio::io_context& io, const yplatform::ptree& data)
        : io(io) {
    using yamail::data::deserialization::fromPtree;

    config = fromPtree<Config>(data);

    if (!pa::async_profiler::is_init()) {
        pa::async_profiler::init(1000000, 16000, config.profilerLogName);
    }
}

void Module::start() {
    workers = std::make_unique<WorkersPool>(io.get(), config);
}

void Module::stop() {
    workers.reset();
}

} // namespace collie::directory_sync

DEFINE_SERVICE_OBJECT(collie::directory_sync::Module)
