#pragma once

#include "workers_pool.hpp"

#include <yplatform/module.h>

namespace collie::directory_sync {

class Module : public yplatform::module {
public:
    Module(boost::asio::io_context& io, const yplatform::ptree& config);

    void start();
    void stop();

private:
    std::reference_wrapper<boost::asio::io_context> io;
    Config config;
    std::unique_ptr<WorkersPool> workers;
};

} // namespace collie::directory_sync
