#include "run_worker.hpp"

#include <src/get_io_context.hpp>

namespace collie::directory_sync {

void RunWorker::operator ()(boost::asio::yield_context yield, std::size_t index) const {
    while (true) {
        const auto id = yplatform::task_context().uniq_id();
        const auto context = std::make_shared<WorkerContext>(
            boost::make_shared<TaskContext>(
                id,
                id,
                "127.0.0.1",
                "collie_worker",
                yield
            )
        );
        const Worker worker(
                makeEventsQueueConnectionProvider,
                makeConnProviderWithCheckUserExists,
                makeConnProviderWithoutCheckUserExists,
                directoryClient,
                config);
        contexts.get().unique_lock()->insert(context);
        LOGDOG_(context->logger(), notice,
            log::message="worker " + std::to_string(index) + " is started"
        );
        try {
            worker(context);
            LOGDOG_(context->logger(), notice,
                log::message="worker " + std::to_string(index) + " is stopped"
            );
            return;
        } catch (const boost::coroutines::detail::forced_unwind&) {
            throw;
        } catch (const std::exception& e) {
            logException(context->logger(), e);
        } catch (...) {
            LOGDOG_(context->logger(), error,
                log::message="unknown error in worker processing"
            );
        }
        contexts.get().unique_lock()->erase(context);
        const auto sleepInterval = std::chrono::seconds(1);
        LOGDOG_(context->logger(), error,
            log::message="worker is crashed, will restart after "
                + std::to_string(sleepInterval.count()) + " seconds"
        );
        boost::asio::steady_timer timer(getIoContext(yield));
        timer.expires_after(sleepInterval);
        timer.async_wait(yield);
    }
}

} // namespace collie::directory_sync
