#pragma once

#include "config.hpp"
#include "worker.hpp"

#include <src/services/db/contacts/make_connection_provider.hpp>
#include <src/services/db/events_queue/make_connection_provider.hpp>
#include <src/services/directory/directory_client_impl.hpp>
#include <src/guarded.hpp>

#include <boost/range/algorithm/for_each.hpp>
#include <boost/range/irange.hpp>
#include <boost/asio/spawn.hpp>

namespace collie::directory_sync {

class RunWorker {
public:
    using MakeEventsQueueConnectionProvider = services::db::events_queue::MakeConnectionProvider;
    using DirectoryClient = services::directory::DirectoryClientImpl;
    using WithoutCheckIsUserExists = services::db::contacts::WithoutCheckIsUserExists;
    using WithCheckIsUserExists = services::db::contacts::WithCheckIsUserExists;
    using MakeConnectionProviderWithCheckUserExists = services::db::contacts::MakeConnectionProvider<WithCheckIsUserExists>;
    using MakeConnectionProviderWithoutCheckUserExists = services::db::contacts::MakeConnectionProvider<WithoutCheckIsUserExists>;

    RunWorker(MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider,
            MakeConnectionProviderWithCheckUserExists makeConnProviderWithCheckUserExists,
            MakeConnectionProviderWithoutCheckUserExists makeConnProviderWithoutCheckUserExists,
            DirectoryClientPtr directoryClient,
            guarded<std::set<WorkerContextPtr>>& contexts,
            const Config& config)
            : makeEventsQueueConnectionProvider(std::move(makeEventsQueueConnectionProvider))
            , makeConnProviderWithCheckUserExists(std::move(makeConnProviderWithCheckUserExists))
            , makeConnProviderWithoutCheckUserExists(std::move(makeConnProviderWithoutCheckUserExists))
            , directoryClient(directoryClient)
            , contexts(contexts)
            , config(config) {
    }

    void operator()(boost::asio::yield_context yield, std::size_t index) const;

private:
    MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider;
    MakeConnectionProviderWithCheckUserExists makeConnProviderWithCheckUserExists;
    MakeConnectionProviderWithoutCheckUserExists makeConnProviderWithoutCheckUserExists;
    DirectoryClientPtr directoryClient;
    std::reference_wrapper<guarded<std::set<WorkerContextPtr>>> contexts;
    const Config& config;
};

} // namespace collie::directory_sync
