#pragma once

#include <src/task_context.hpp>

namespace collie::directory_sync {

class WorkerContext {
public:
    WorkerContext(TaskContextPtr sub)
        : sub_(sub) {}

    TaskContextPtr sub() const {
        return sub_;
    }

    const boost::asio::yield_context& yield() const {
        return sub_->yield();
    }

    const RequestLogger& logger() const {
        return sub_->logger();
    }

    bool shouldStop() const {
        return shouldStop_.load();
    }

    void stop() {
        shouldStop_ = true;
    }

private:
    TaskContextPtr sub_;
    std::atomic_bool shouldStop_ {false};
};

using WorkerContextPtr = std::shared_ptr<WorkerContext>;

} // namespace collie::directory_sync
