#pragma once

#include "config.hpp"
#include "worker_context.hpp"

#include <src/guarded.hpp>

#include <boost/asio/io_context.hpp>

#include <set>

namespace collie::directory_sync {

class WorkersPool {
public:
    WorkersPool(boost::asio::io_context& io, const Config& config);
    ~WorkersPool();

private:
    boost::asio::executor_work_guard<boost::asio::io_context::executor_type> guard;
    std::thread thread;
    guarded<std::set<WorkerContextPtr>> contexts;
};

} // namespace collie::directory_sync
