#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>

#include <yplatform/log.h>

namespace collie {
namespace log {

LOGDOG_DEFINE_ATTRIBUTE(int, http_status)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, client_user_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, list_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, ml_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, org_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, owner_list_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, owner_user_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, revision)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, staff_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, tag_id)
LOGDOG_DEFINE_ATTRIBUTE(std::int64_t, user_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, conn_info)
LOGDOG_DEFINE_ATTRIBUTE(std::string, list_name)
LOGDOG_DEFINE_ATTRIBUTE(std::string, list_type)
LOGDOG_DEFINE_ATTRIBUTE(std::string, request_body)
LOGDOG_DEFINE_ATTRIBUTE(std::string, request_url)
LOGDOG_DEFINE_ATTRIBUTE(std::string, response_body)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uniq_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string_view, pq_message)
LOGDOG_DEFINE_ATTRIBUTE(std::string_view, query)
LOGDOG_DEFINE_ATTRIBUTE(std::time_t, sync_timestamp)

using logdog::attr::exception;
using logdog::attr::message;
using logdog::attr::request_id;
using logdog::attr::where_name;
using logdog::attr::error_code;

constexpr static auto collie_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-collie-tskv-log"));

static const std::string collieLogKey("collie");

} // namespace log

inline auto getLogger() {
    using yplatform::log::source;
    return logdog::make_log(
        log::collie_formatter,
        std::make_shared<source>(YGLOBAL_LOG_SERVICE, log::collieLogKey)
    );
}

inline auto getLogger(const std::string& uniqId, const std::string& requestId) {
    return logdog::bind(getLogger(), log::uniq_id=uniqId, log::request_id=requestId);
}

using RequestLogger = decltype(getLogger(std::string(), std::string()));

template <class Logger, class ... Ts>
void logException(const Logger& logger, const std::exception& e, const Ts& ... args) {
    try {
        std::rethrow_if_nested(e);
    } catch (const std::exception& inner) {
        logException(logger, inner, args ...);
    }
    LOGDOG_(logger, error, log::exception=e, args ...);
}

} // namespace collie
