#pragma once

#include <src/logic/interface/add_directory_event.hpp>

namespace collie::logic::db {

template<typename GetEventQueueModule> class AddDirectoryEventImpl final : public AddDirectoryEvent {
public:
    explicit AddDirectoryEventImpl(GetEventQueueModule getEventQueueModule)
        : getEventQueueModule(std::move(getEventQueueModule)) {
    }

    expected<void> operator()(const TaskContextPtr&, NewEvent event) const override {
        getEventQueueModule()->addEvent(std::move(event));
        return {};
    }

private:
    const GetEventQueueModule getEventQueueModule;
};

} // namespace collie::logic::db
