#include "carddav_utils.hpp"

#include <boost/fusion/include/fold.hpp>
#include <boost/range/algorithm.hpp>
#include <boost/lexical_cast.hpp>

using std::string_literals::operator""s;
using collie::services::db::contacts::CarddavContactRow;

namespace collie::logic::db {

std::string getDisplayName(const Vcard& vcard) {
    if (!vcard.names || vcard.names->empty()) {
        return ""s;
    }
    const auto& namesVector = vcard.names.value();
    const auto it = boost::range::find_if(namesVector, [](const auto& name) {
        return name.first || name.last;
    });
    if (it == namesVector.end()) {
        return ""s;
    }

    return  boost::fusion::fold(*it, ""s, [](const std::string& result, const auto& value) {
        return result + (value ? (result.empty() ? ""s : " "s) + value.value() : ""s);
    });
}

std::string getUri(const CarddavContactRow& contact) {
    return contact.uri ? contact.uri.value() : "YA-"s + boost::lexical_cast<std::string>(contact.contact_id);
}

std::string getEtag(const CarddavContactRow& contact) {
    return R"(")" + boost::lexical_cast<std::string>(contact.contact_id) +
        "-"s + boost::lexical_cast<std::string>(contact.revision) + R"(")";
}

std::string getEtag(std::int64_t contact_id, std::int64_t revision) {
    return R"(")" + boost::lexical_cast<std::string>(contact_id) +
        "-"s + boost::lexical_cast<std::string>(revision) + R"(")";
}

} // namespace collie::logic::db
