#pragma once

#include <src/logic/interface/types/revision.hpp>

#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

#include <src/expected.hpp>

namespace collie::logic::db::contacts {

template <class Connection>
expected<Revision> acquireRevision(Connection&& connection) {
    using services::db::request;
    using services::db::unwrap;
    using services::db::contacts::query::AcquireRevision;

    AcquireRevision query;
    query.uid = unwrap(connection).uid();
    query.user_type = unwrap(connection).userType();
    return request(connection, std::as_const(query))
        .bind([] (auto&& rows) {
            return services::db::expectSingleRow(std::move(rows));
        });
}

} // namespace collie::logic::db::contacts
