#include "create_contacts.hpp"

#include <src/logic/interface/types/reflection/vcard.hpp>

#include <yamail/data/serialization/yajl.h>

namespace collie::logic::db::contacts {

std::vector<services::db::contacts::NewContact> createQueryContacts(
        std::vector<NewContact>& newContacts, const std::optional<ListId>& defaultListId) {
    using yamail::data::serialization::toJson;

    std::vector<services::db::contacts::NewContact> queryContacts;
    std::transform(newContacts.begin(), newContacts.end(), std::back_inserter(queryContacts),
        [&] (auto& contact) {
            auto emails{std::move(contact.vcard.emails)};
            contact.vcard.emails.reset();
            ozo::pg::jsonb vcard(toJson(contact.vcard));
            contact.vcard.emails = std::move(emails);

            return services::db::contacts::NewContact {
                contact.list_id ? *contact.list_id : *defaultListId,
                services::db::contacts::VcardFormat {"vcard_v1"},
                std::move(vcard),
                std::move(contact.uri)
            };
        });

    return queryContacts;
}

std::vector<services::db::contacts::NewContactsEmail> createQueryEmails(
        const std::vector<ContactId>& contactIds, std::vector<NewContact>& newContacts) {
    std::vector<services::db::contacts::NewContactsEmail> queryEmails;
    for (auto index = 0u; index < contactIds.size(); ++index) {
        auto& emails(newContacts[index].vcard.emails);
        if (emails) {
            for (auto& email : *emails) {
                if (!email.email) {
                    continue;
                }
                if (email.email.value().empty()) {
                    continue;
                }
                queryEmails.emplace_back(services::db::contacts::NewContactsEmail {
                    contactIds[index],
                    email.email,
                    email.type,
                    email.label
                });
            }
        }
    }

    return queryEmails;
}

std::unordered_map<TagId, std::vector<ContactId>> createTagToContactsMap(
        const std::vector<ContactId>& contactIds, const std::vector<NewContact>& newContacts) {
    std::unordered_map<TagId, std::vector<ContactId>> tagToContacts;
    for (auto index = 0u; index < contactIds.size(); ++index) {
        const auto& tagIds(newContacts[index].tag_ids);
        if (tagIds) {
            for (auto tagId : *tagIds) {
                tagToContacts[tagId].emplace_back(contactIds[index]);
            }
        }
    }

    return tagToContacts;
}

std::map<TagId, std::vector<EmailId>> makeTagsToEmailIds(
    const CreatedEmails& createdEmails,
    const std::vector<ContactId>& contactIds,
    const std::vector<NewContact>& newContacts)
{
    std::map<TagId, std::vector<EmailId>> tagToEmailsIds;
    size_t emailIndex = 0u;
    for (auto contactsIndex = 0u; contactsIndex < contactIds.size(); ++contactsIndex) {
        const auto& tagIds(newContacts[contactsIndex].tag_ids);
        const auto& emails(newContacts[contactsIndex].vcard.emails);
        if (emails) {
            for (auto email: *emails) {
                if (!email.email) {
                    continue;
                }
                if (email.email.value().empty()) {
                    continue;
                }
                if (tagIds) {
                    for (auto tagId : *tagIds) {
                        tagToEmailsIds[tagId].emplace_back(createdEmails.email_ids[emailIndex]);
                    }
                }
                ++emailIndex;
            }
        }
    }
    return tagToEmailsIds;
}

} // namespace collie::logic::db::contacts
