#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/created_list.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<CreatedList> createContactsList(Connection&& connection,
        std::string name) {
    services::db::contacts::query::CreateContactsList query;
    const auto uid{services::db::unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = services::db::unwrap(connection).userType();
    query.name = std::move(name);
    query.type = "user";
    const auto context{services::db::unwrap(connection).context()};
    query.x_request_id = context->requestId();
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        const auto result(services::db::expectSingleRow(std::move(rows)));
        LOGDOG_(context->logger(), notice, log::query=ozo::get_query_name(query), log::uid=std::to_string(
                uid), log::list_name=query.name, log::revision=result.revision, log::list_id=result.list_id);
        return CreatedList{result.revision, result.list_id};
    });
}

} // namespace collie::logic::db::contacts
