#pragma once

#include "utils.hpp"

#include <src/expected.hpp>
#include <src/logic/interface/types/contact_id.hpp>
#include <src/logic/interface/types/existing_contacts.hpp>
#include <src/logic/interface/types/list_id.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

template<typename Query, typename Connection> expected<ExistingContacts> getContacts(
        Connection&& connection,
        std::vector<ContactId> contactIds,
        std::vector<ListId> listIds,
        std::optional<std::int64_t> offset,
        std::optional<std::int64_t> limit) {
    const auto uid{services::db::unwrap(connection).uid()};
    Query query{uid, services::db::unwrap(connection).userType(), std::move(contactIds), std::move(listIds),
            std::move(offset), std::move(limit)};
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                log::query=ozo::get_query_name(query), log::uid=std::to_string(uid));
        return makeExistingContacts(std::move(rows));
    });
}

} // namespace collie::logic::db::contacts
