#pragma once

#include "utils.hpp"

#include <src/expected.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<ExistingContacts> getContactsByTagId(
        Connection&& connection,
        TagId tagId,
        std::optional<std::int64_t> offset,
        std::optional<std::int64_t> limit) {
    using services::db::unwrap;
    const auto uid{unwrap(connection).uid()};
    services::db::contacts::query::GetContactsByTagId query{uid, tagId, std::move(offset), std::move(limit)};
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(unwrap(connection).context()->logger(), notice, log::query=ozo::get_query_name(query),
                log::uid=std::to_string(uid), log::tag_id=tagId);
        return makeExistingContacts(std::move(rows));
    });
}

} // namespace collie::logic::db::contacts
