#pragma once

#include <src/expected.hpp>
#include <src/services/db/contacts/types/reflection/carddav_contact_row.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

    template<typename Connection> expected<std::vector<collie::services::db::contacts::CarddavContactRow>>
    getContactsByTagNameAndTagTypeAndUris(
            Connection&& connection, std::string tagType, std::string tagName, std::vector<std::string> uris
    ) {
        services::db::contacts::query::GetContactsByTagNameAndTagTypeAndUris query;
        using services::db::unwrap;
        const auto uid {unwrap(connection).uid()};
        query.uid = uid;
        query.user_type = unwrap(connection).userType();
        query.tag_type = std::move(tagType);
        query.tag_name = std::move(tagName);
        query.uris = std::move(uris);
        return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
            LOGDOG_(unwrap(connection).context()->logger(), notice, log::query = ozo::get_query_name(query),
                    log::uid = std::to_string(uid));
            return rows;
        });
    }
}
