#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/list_id.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db::contacts {

template<typename Query, typename Connection> expected<std::int64_t> getContactsCount(Connection&& connection,
        std::vector<ListId> listIds) {
    const auto uid{services::db::unwrap(connection).uid()};
    Query query{uid, services::db::unwrap(connection).userType(), std::move(listIds)};
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                log::query=ozo::get_query_name(query), log::uid=std::to_string(uid));
        return services::db::expectSingleRow(std::move(rows));
    });
}

} // namespace collie::logic::db::contacts
