#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/email_id.hpp>
#include <src/logic/interface/types/tag_id.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<std::vector<EmailId>> getContactsEmailIdsByContactIdAndTagIds(
        Connection&& connection, ContactId contactId, std::vector<TagId> tagIds) {
    services::db::contacts::query::GetContactsEmailIdsByContactIdAndTagIds query;
    using services::db::unwrap;
    const auto uid{unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = unwrap(connection).userType();
    query.contact_id = contactId;
    query.tag_ids = std::move(tagIds);
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(unwrap(connection).context()->logger(), notice, log::query=ozo::get_query_name(query),
                log::uid=std::to_string(uid));
        return rows;
    });
}

} // namespace collie::logic::db::contacts
