#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/contact_id.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

template<typename Connection>
expected<std::vector<services::db::contacts::ContactIdEmailIdEmailRow>> getContactsEmailIdsByContactsIds(
        Connection&& connection, std::vector<ContactId> contactIds) {
    services::db::contacts::query::GetContactsEmailIdsByContactsIds query;
    const auto uid{services::db::unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = services::db::unwrap(connection).userType();
    query.contacts_ids = std::move(contactIds);
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                log::query=ozo::get_query_name(query), log::uid=std::to_string(uid));
        return rows;
    });
}

} // namespace collie::logic::db::contacts
