#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/get_emails_result.hpp>
#include <src/logic/utils.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

#include <boost/range/algorithm/for_each.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<GetEmailsResult> getContactsEmailsByTagIds(
        Connection&& connection, std::vector<TagId> tagIds) {
    services::db::contacts::query::GetContactsEmailsByTagIds query;
    using services::db::unwrap;
    const auto uid{unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = unwrap(connection).userType();
    query.tag_ids = std::move(tagIds);
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(unwrap(connection).context()->logger(), notice, log::query=ozo::get_query_name(query),
                log::uid=std::to_string(uid));
        std::map<TagId, std::vector<ExistingEmail>> mappedEmails;
        const auto inserter{[&](auto&& row){mappedEmails[row.tag_id].emplace_back(ExistingEmail{row.email_id,
                row.contact_id, row.revision, std::move(row.email), std::move(row.type),
                        std::move(row.label)});}};
        boost::for_each(rows, std::move(inserter));
        return makeGetEmailsResult(std::move(mappedEmails));
    });
}

} // namespace collie::logic::db::contacts
