#pragma once

#include <src/logic/interface/types/list_id.hpp>

#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

#include <src/expected.hpp>

#include <optional>

namespace collie::logic::db::contacts {

template <class Connection>
expected<ListId> getDefaultListId(Connection&& connection) {
    using services::db::request;
    services::db::contacts::query::GetDefaultListId query;
    query.uid = services::db::unwrap(connection).uid();
    query.user_type = services::db::unwrap(connection).userType();
    return request(connection, std::as_const(query))
        .bind([] (auto&& rows) {
            return services::db::expectSingleRow(std::move(rows));
        });
}

template<typename Connection>
expected<std::optional<ListId>> getDefaultListIdNoThrow(Connection&& connection) {
    using services::db::request;
    services::db::contacts::query::GetDefaultListId query;
    query.uid = services::db::unwrap(connection).uid();
    query.user_type = services::db::unwrap(connection).userType();
    return request(connection, std::as_const(query)).bind([](auto&& rows) {
        return (std::size(rows) == 1u) ? std::make_optional(std::move(*std::begin(rows))) : std::nullopt;
    });
}

} // namespace collie::logic::db::contacts
