#pragma once

#include <src/logic/interface/types/revision.hpp>
#include <src/logic/interface/types/directory_entity.hpp>

#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

#include <src/expected.hpp>

namespace collie::logic::db::contacts {

template <class Connection>
expected<std::vector<DirectoryEntity>> getDirectoryEntities(Connection&& connection) {
    using services::db::request;
    using services::db::unwrap;

    services::db::contacts::query::GetDirectoryEntities query;
    query.uid = unwrap(connection).uid();
    query.user_type = unwrap(connection).userType();

    return request(connection, std::as_const(query))
        .bind([&] (auto&& rows) {
            std::vector<DirectoryEntity> result;
            result.reserve(rows.size());
            boost::transform(std::move(rows), std::back_inserter(result),
                [] (auto&& row) {
                    return DirectoryEntity {
                        DirectoryEntityId {row.id},
                        makeDirectoryEntityType(row.type.get()),
                        ContactId {row.contact_id}
                    };
                });
            return result;
        });
}

} // namespace collie::logic::db::contacts
