#pragma once

#include "utils.hpp"

#include <src/expected.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<ExistingContacts> getSharedContacts(
        Connection&& connection,
        std::int64_t clientUserId,
        std::string clientUserType,
        std::vector<std::int64_t> listIds
    ) {
    services::db::contacts::query::GetSharedContacts query;
    const auto uid {services::db::unwrap(connection).uid()};
    collie::services::db::ConstUserType userType {clientUserType};
    query.uid = uid;
    query.user_type = services::db::unwrap(connection).userType();
    query.client_uid = std::move(clientUserId);
    query.client_user_type = std::move(userType);
    query.list_ids = std::move(listIds);
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                log::query = ozo::get_query_name(query), log::uid = std::to_string(uid));
        return makeExistingContacts(std::move(rows));
    });
}

} // namespace collie::logic::db::contacts
