#pragma once

#include "src/services/db/utils.hpp"

#include <src/expected.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<std::int64_t> getSharedContactsCount(
        Connection&& connection,
        std::int64_t clientUserId,
        std::string clientUserType,
        std::vector<std::int64_t> listIds
    ) {
    services::db::contacts::query::GetSharedContactsCount query;
    using services::db::unwrap;
    const auto uid {unwrap(connection).uid()};
    collie::services::db::ConstUserType userType {clientUserType};
    query.uid = uid;
    query.user_type = unwrap(connection).userType();
    query.client_uid = std::move(clientUserId);
    query.client_user_type = std::move(userType);
    query.list_ids = std::move(listIds);
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(unwrap(connection).context()->logger(), notice, log::query = ozo::get_query_name(query),
                log::uid = std::to_string(uid));
        return services::db::expectSingleRow(std::move(rows));
    });
}

} // namespace collie::logic::db::contacts
