#pragma once

#include <src/expected.hpp>
#include <src/services/db/contacts/types/reflection/subscribed_list.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db::contacts {

using SubscribeListOpt = std::optional<services::db::contacts::SubscribeList>;

template<typename Connection> expected<SubscribeListOpt>
getSubscribedList(Connection&& connection, ListId listId) {
    services::db::contacts::query::GetSubscribedList query;
    const auto uid {services::db::unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = services::db::unwrap(connection).userType();
    query.list_id = listId;
    return services::db::request(connection, std::as_const(query))
        .bind([&](auto&& rows) -> expected<SubscribeListOpt> {
            LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                    log::query = ozo::get_query_name(query), log::uid = std::to_string(uid));
            if (std::empty(rows)) {
                return {};
            }
            return std::make_optional(services::db::expectSingleRow(std::move(rows)));
        });
}

}
