#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/list_id.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<std::vector<ListId>> getSubscribedListIdsByOwner(
        Connection&& connection, std::int64_t ownerUserId, std::string ownerUserType) {
    services::db::contacts::query::GetSubscribedListIdsByOwner query;
    const auto uid{services::db::unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = services::db::unwrap(connection).userType();
    query.owner_uid = ownerUserId;
    query.owner_user_type = ownerUserType;
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        LOGDOG_(services::db::unwrap(connection).context()->logger(),
                notice,
                log::query = ozo::get_query_name(query),
                log::uid = std::to_string(uid),
                log::owner_user_id = ownerUserId);
        return std::move(rows);
    });
}

} // namespace collie::logic::db::contacts
