#pragma once

#include <src/expected.hpp>
#include <src/services/db/contacts/types/reflection/subscribed_list.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

namespace collie::logic::db::contacts {

    template<typename Connection> expected<std::vector<services::db::contacts::SubscribeList>>
    getSubscribedLists(Connection&& connection) {
        services::db::contacts::query::GetSubscribedLists query;
        const auto uid {services::db::unwrap(connection).uid()};
        query.uid = uid;
        query.user_type = services::db::unwrap(connection).userType();
        return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
            LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                    log::query = ozo::get_query_name(query), log::uid = std::to_string(uid));
            return rows;
        });
    }
}
