#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/reflection/existing_tag.hpp>
#include <src/logic/interface/types/tag_id.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<ExistingTag> getTagById(Connection&& connection, TagId tagId) {
    services::db::contacts::query::GetTagById query;
    using services::db::unwrap;
    const auto uid{unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = unwrap(connection).userType();
    query.tag_id = tagId;
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        auto&& row(services::db::expectSingleRow(std::move(rows)));
        LOGDOG_(unwrap(connection).context()->logger(), notice, log::query=ozo::get_query_name(query),
                log::uid=std::to_string(uid), log::tag_id=tagId);
        return ExistingTag{row.tag_id, makeTagType(row.type.get()), std::move(row.name), row.contacts_count,
                row.revision};
    });
}

} // namespace collie::logic::db::contacts
