#pragma once

#include <src/expected.hpp>
#include <src/services/db/contacts/types/tag_id.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db::contacts {

    template<typename Connection> expected<collie::services::db::contacts::TagId>
    getTagIdByTagNameAndTagType(
            Connection&& connection, std::string tagType, std::string tagName
    ) {
        services::db::contacts::query::GetTagIdByTagNameAndTagType query;
        using services::db::unwrap;
        const auto uid {unwrap(connection).uid()};
        query.uid = uid;
        query.user_type = unwrap(connection).userType();
        query.tag_type = std::move(tagType);
        query.tag_name = std::move(tagName);
        return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
            LOGDOG_(unwrap(connection).context()->logger(), notice, log::query = ozo::get_query_name(query),
                    log::uid = std::to_string(uid));
            return services::db::expectSingleRow(std::move(rows));
        });
    }
} // collie::logic::db::contacts
