#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/existing_shared_list.hpp>
#include <src/logic/interface/types/existing_shared_lists.hpp>
#include <src/logic/interface/types/reflection/existing_shared_list.hpp>
#include <src/services/db/connection_provider.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/contacts/types/reflection/existing_shared_list_row.hpp>
#include <logdog/logger.h>
#include <ozo/query_conf.h>
#include <boost/range/algorithm/transform.hpp>
#include <utility>
#include <iterator>

namespace collie::logic::db::contacts {

template <typename Connection>
expected<ExistingSharedLists> getUserTypeLists(Connection&& connection) {
    services::db::contacts::query::GetUserTypeLists query;
    query.uid = services::db::unwrap(connection).uid();
    return services::db::request(connection, std::as_const(query)).bind([&] (auto&& result) {
        ExistingSharedLists lists;
        lists.lists.reserve(result.size());
        boost::transform(result, std::back_inserter(lists.lists), [](auto& row) {
            return ExistingSharedList {row.list_id, std::move(row.name)};
        });
        LOGDOG_(services::db::unwrap(connection).context()->logger(), notice, log::query=ozo::get_query_name(query),
                log::uid=std::to_string(query.uid));
        return lists;
    });
}

} // namespace collie::logic::db::contacts
