#pragma once

#include <src/services/db/contacts/query.hpp>
#include <src/services/db/execute.hpp>
#include <src/services/db/utils.hpp>

#include <src/expected.hpp>

namespace collie::logic::db::contacts {

template <class Connection>
expected<void> purgeContactsUser(Connection&& connection, bool force = false, bool full = true) {
    using services::db::execute;
    services::db::contacts::query::PurgeContactsUser query;
    query.uid = services::db::unwrap(connection).uid();
    query.user_type = services::db::unwrap(connection).userType();
    query.force = force;
    query.full = full;
    return execute(connection, std::as_const(query))
        .bind([&]{return make_expected();});
}

} // namespace collie::logic::db::contacts
