#pragma once

#include <src/logic/interface/types/revision.hpp>
#include <src/logic/interface/types/directory_entity_id_and_type.hpp>

#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

#include <src/expected.hpp>

#include <boost/range/algorithm/transform.hpp>

namespace collie::logic::db::contacts {

template <class Connection>
expected<Revision> removeDirectoryEntities(const std::vector<DirectoryEntityIdAndType>& directoryEntities,
        Connection&& connection) {
    using services::db::request;
    using services::db::unwrap;
    using services::db::contacts::query::RemoveDirectoryEntities;
    using DbDirectoryEntityType = services::db::contacts::DirectoryEntityType;
    using DbDirectoryEntityIdAndType = services::db::contacts::DirectoryEntityIdAndType;

    const auto context = unwrap(connection).context();

    RemoveDirectoryEntities query;
    query.uid = unwrap(connection).uid();
    query.user_type = unwrap(connection).userType();
    query.x_request_id = context->requestId();

    query.directory_entities.reserve(directoryEntities.size());

    boost::transform(directoryEntities, std::back_inserter(query.directory_entities),
        [&] (const auto& v) {
            return DbDirectoryEntityIdAndType {v.id, DbDirectoryEntityType {toString(v.type)}};
        });

    return request(connection, std::as_const(query))
        .bind([&] (auto&& result) { return services::db::expectSingleRow(std::move(result)); });
}

} // namespace collie::logic::db::contacts
