#pragma once

#include "get_contacts_email_ids_by_contacts_ids.hpp"
#include "get_contacts_ids_by_contacts_email_ids.hpp"
#include "tag_contacts.hpp"
#include "tag_contacts_emails.hpp"

#include <src/expected.hpp>
#include <src/logic/interface/types/contact_email_id.hpp>
#include <src/logic/interface/types/revision.hpp>
#include <src/logic/interface/types/tag_id.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

#include <boost/range/algorithm/transform.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<Revision> tagContactsAndContactsEmails(
        Connection&& connection,
        TagId tagId,
        std::vector<ContactId> addContactIds,
        std::vector<ContactsEmailId> addContactEmailIds) {
    std::vector<ContactId> tagContactsIds(addContactIds);
    std::vector<EmailId> tagContactEmailIds;
    boost::range::transform(addContactEmailIds, std::back_inserter(tagContactEmailIds),
            [](const auto& row){return row.email_id;});

    if (!addContactEmailIds.empty()) {
        auto result{contacts::getContactsIdsByContactsEmailIds(connection, tagContactEmailIds)};
        if (!result) {
            return make_unexpected(std::move(result).error());
        }

        boost::range::transform(result.value(), std::back_inserter(tagContactsIds),
                [](const auto& row){return row.contact_id;});
    }

    if (!addContactIds.empty()) {
        auto result{contacts::getContactsEmailIdsByContactsIds(connection, addContactIds)};
        if (!result) {
            return make_unexpected(std::move(result).error());
        }

        boost::range::transform(result.value(), std::back_inserter(tagContactEmailIds),
                [](const auto& row){return row.email_id;});
    }

    auto revision{make_expected(Revision{})};
    if (!tagContactsIds.empty()) {
        revision = contacts::tagContacts(connection, tagId, std::move(tagContactsIds));
        if (!revision) {
            return revision;
        }
    }

    if (!tagContactEmailIds.empty()) {
        revision = contacts::tagContactsEmails(connection, tagId, std::move(tagContactEmailIds));
    }

    return revision;
}

}
