#pragma once

#include "get_contacts_email_ids_by_contact_id_and_tag_ids.hpp"
#include "get_contacts_email_ids_by_contacts_ids.hpp"
#include "get_contacts_ids_by_contacts_email_ids.hpp"
#include "untag_contacts.hpp"
#include "untag_contacts_emails.hpp"

#include <src/expected.hpp>
#include <src/logic/interface/types/contact_email_id.hpp>
#include <src/logic/interface/types/revision.hpp>
#include <src/logic/interface/types/tag_id.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>

#include <boost/range/algorithm/transform.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<Revision> untagContactsAndContactsEmails(
        Connection&& connection,
        TagId tagId,
        std::vector<ContactId> removeContactIds,
        std::vector<ContactsEmailId> removeContactEmailIds) {
    std::vector<ContactId> contactsIdsByEmails;
    std::vector<EmailId> untagContactEmailIds;
    boost::range::transform(removeContactEmailIds, std::back_inserter(untagContactEmailIds),
            [](const auto& row){return row.email_id;});

    if (!removeContactEmailIds.empty()) {
        auto result{contacts::getContactsIdsByContactsEmailIds(connection, untagContactEmailIds)};
        if (!result) {
            return make_unexpected(std::move(result).error());
        }

        boost::range::transform(result.value(), std::back_inserter(contactsIdsByEmails),
                [](const auto& row){return row.contact_id;});
    }

    if (!removeContactIds.empty()) {
        auto result{contacts::getContactsEmailIdsByContactsIds(connection, removeContactIds)};
        if (!result) {
            return make_unexpected(std::move(result).error());
        }

        boost::range::transform(result.value(), std::back_inserter(untagContactEmailIds),
                [](const auto& row){return row.email_id;});
    }

    auto revision{make_expected(Revision{})};
    if (!untagContactEmailIds.empty()) {
        revision = contacts::untagContactsEmails(connection, tagId, std::move(untagContactEmailIds));
        if (!revision) {
            return revision;
        }
    }

    for (auto contactId : contactsIdsByEmails) {
        auto result{contacts::getContactsEmailIdsByContactIdAndTagIds(connection, contactId, {tagId})};
        if (!result) {
            return make_unexpected(std::move(result).error());
        }

        if (result.value().empty()) {
            removeContactIds.push_back(contactId);
        }
    }

    if (!removeContactIds.empty()) {
        revision = contacts::untagContacts(connection, tagId, std::move(removeContactIds));
    }

    return revision;
}

}
