#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/email_id.hpp>
#include <src/logic/interface/types/revision.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db::contacts {

template<typename Connection> expected<Revision> untagContactsEmails(Connection&& connection, TagId tagId,
        std::vector<EmailId> emailIds) {
    services::db::contacts::query::UntagContactsEmails query;
    using services::db::unwrap;
    const auto uid{unwrap(connection).uid()};
    query.uid = uid;
    query.user_type = unwrap(connection).userType();
    query.tag_id = tagId;
    query.email_ids = std::move(emailIds);
    const auto context{unwrap(connection).context()};
    query.x_request_id = context->requestId();
    return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
        const auto revision(services::db::expectSingleRow(std::move(rows)));
        LOGDOG_(context->logger(), notice, log::query=ozo::get_query_name(query),
                log::uid=std::to_string(uid), log::tag_id=tagId, log::revision=revision);
        return revision;
    });
}

} // namespace collie::logic::db::contacts
