#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/revision.hpp>
#include <src/logic/interface/types/tag_id.hpp>
#include <src/logic/interface/types/updated_tag.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db::contacts {

template<typename Connection>
expected<Revision> updateTag(Connection&& connection, TagId tagId, const UpdatedTag& updatedTag) {
    using services::db::unwrap;
    const auto context{unwrap(connection).context()};
    const auto uid{unwrap(connection).uid()};
    services::db::contacts::query::UpdateTag q;
    q.uid = uid;
    q.tag_id = tagId;
    q.name = updatedTag.name;
    q.x_request_id = context->requestId();
    q.revision = updatedTag.revision;

    return services::db::request(connection, std::as_const(q)).bind([&] (auto&& result) {
        const auto revision(services::db::expectSingleRow(std::move(result)));
        LOGDOG_(context->logger(), notice,
            log::query=ozo::get_query_name(q),
            log::uid=std::to_string(uid),
            log::tag_id=tagId,
            log::revision=revision);
        return revision;
    });
}

} // namespace collie::logic::db::contacts
