#include "utils.hpp"

#include <src/logic/interface/types/existing_contacts.hpp>
#include <src/logic/interface/types/reflection/vcard.hpp>

#include <yamail/data/deserialization/json_reader.h>

namespace collie::logic::db::contacts {

ExistingContacts makeExistingContacts(std::vector<services::db::contacts::ExistingContactRow>&& rows) {
    ExistingContacts contacts;
    contacts.contacts.reserve(rows.size());
    auto transformContact{[](auto&& row) {
        using yamail::data::deserialization::fromJson;
        ExistingContact contact{row.contact_id, row.list_id, row.revision, fromJson<Vcard>(row.vcard),
                std::move(row.tag_ids), std::move(row.uri), {}};
        auto transformEmail{[](auto&& rowEmail){return EmailWithTags{rowEmail.email_id,
                std::move(rowEmail.email), std::move(rowEmail.tag_ids)};}};
        std::transform(std::make_move_iterator(row.emails.begin()), std::make_move_iterator(
                row.emails.end()), std::back_inserter(contact.emails), std::move(transformEmail));
        return contact;
    }};

    std::transform(std::make_move_iterator(rows.begin()), std::make_move_iterator(rows.end()),
            std::back_inserter(contacts.contacts), std::move(transformContact));
    return contacts;
}

} // namespace collie::logic::db::contacts
