#pragma once

#include <src/logic/interface/create_tag.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/passport_user_id.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

namespace collie::logic::db {

template <class MakeConnectionProvider>
class CreateTagImpl final : public CreateTag {
public:
    explicit CreateTagImpl(MakeConnectionProvider makeConnectionProvider)
        : makeConnectionProvider(std::move(makeConnectionProvider)) {
    }

    expected<CreatedTag> operator()(const TaskContextPtr& context, const Uid& uid,
            const NewTag& tag) const override {
        using services::db::PassportUserId;

        services::db::contacts::query::CreateTag q;
        if (!boost::conversion::try_lexical_convert<std::int64_t>(uid, q.uid)) {
            return make_unexpected(error_code(Error::userNotFound));
        }

        q.name = tag.name;
        q.x_request_id = context->requestId();
        return services::db::request(
                    services::db::retry(makeConnectionProvider(context, PassportUserId {q.uid})),
                    std::as_const(q)
                ).bind([&] (auto&& result) {
                    const auto createdTag(services::db::expectSingleRow(std::move(result)));
                    LOGDOG_(context->logger(), notice,
                            log::query=ozo::get_query_name(q),
                            log::uid=uid,
                            log::tag_id=createdTag.tag_id,
                            log::revision=createdTag.revision);

                    return CreatedTag{createdTag.tag_id, createdTag.revision};
                });
    }

private:
    MakeConnectionProvider makeConnectionProvider;
};

} // namespace collie::logic::db
