#pragma once

#include <src/expected.hpp>
#include <src/logic/interface/types/org_id.hpp>
#include <src/logic/interface/types/reflection/new_event.hpp>
#include <src/services/db/events_queue/query.hpp>
#include <src/services/db/execute.hpp>

namespace collie::logic::db::events_queue {

template<typename Connection> expected<void> addDirectoryEvents(Connection&& connection, OrgId orgId,
        EventInfo event) {
    services::db::events_queue::query::AddDirectoryEvents query;
    query.user_id = orgId;
    query.event_count = event.count;
    query.event_type = toString(event.event);
    query.event_revision = event.revision;
    return services::db::execute(connection, std::as_const(query));
}

} // namespace collie::logic::db::events_queue
