#pragma once

#include "contacts/get_contacts_emails_by_tag_ids.hpp"

#include <src/logic/interface/get_emails.hpp>
#include <src/services/db/passport_user_id.hpp>

namespace collie::logic::db {

template <class MakeConnectionProvider>
class GetEmailsImpl final : public GetEmails {
public:
    explicit GetEmailsImpl(MakeConnectionProvider makeConnectionProvider)
        : makeConnectionProvider(std::move(makeConnectionProvider)) {
    }

    virtual expected<GetEmailsResult> operator()(
            const TaskContextPtr& context,
            const Uid& uid,
            const std::vector<TagId>& tagIds,
            const std::optional<std::string_view>&) const override {
        std::int64_t numericUid;
        if (!boost::conversion::try_lexical_convert<std::int64_t>(uid, numericUid)) {
            return make_unexpected(error_code(Error::userNotFound));
        }

        if (tagIds.empty()) {
            return make_expected(GetEmailsResult{});
        }

        using services::db::PassportUserId;
        auto provider{services::db::retry(makeConnectionProvider(context, services::db::PassportUserId{
                numericUid}))};
        return contacts::getContactsEmailsByTagIds(std::move(provider), tagIds);
    }

private:
    MakeConnectionProvider makeConnectionProvider;
};

} // namespace collie::logic::db
