#pragma once

#include <src/logic/interface/restore.hpp>
#include <src/logic/error.hpp>
#include <src/services/db/contacts/query.hpp>
#include <src/services/db/passport_user_id.hpp>
#include <src/services/db/request.hpp>
#include <src/services/db/utils.hpp>

#include <boost/hana/core/to.hpp>

namespace collie::logic::db {

template <class MakeConnectionProvider>
class RestoreImpl final : public Restore {
public:
    RestoreImpl(MakeConnectionProvider makeConnectionProvider)
        : makeConnectionProvider(std::move(makeConnectionProvider)) {
    }

    expected<void> operator ()(const TaskContextPtr& context, const Uid& uid,
            const Revision revision) const override {
        using services::db::PassportUserId;

        services::db::contacts::query::RestoreContacts q;
        if (!boost::conversion::try_lexical_convert<std::int64_t>(uid, q.uid)) {
            return make_unexpected(error_code(Error::userNotFound));
        }
        q.revision = revision;
        q.x_request_id = context->requestId();
        return services::db::request(
                services::db::retry(makeConnectionProvider(context, PassportUserId {q.uid})),
                std::as_const(q)
            ).bind([&] (auto&& result) {
                const auto revision = std::get<0>(services::db::expectSingleRow(std::move(result)));
                LOGDOG_(context->logger(), notice,
                    log::query=ozo::get_query_name(q),
                    log::uid=uid,
                    log::revision=revision
                );
            });
    }

private:
    MakeConnectionProvider makeConnectionProvider;
};

} // namespace collie::logic::db
